#include <Nordic\reg24le1.h>
#include <stdint.h>
#include "hal_w2_mod.h"
#include "lib_m24c32.h"

#define M24C32_SERIAL_NUMBER_ADDRESS  0x0000

void generate_random_bytes(uint8_t *data_array, uint8_t array_length)
{
  // Enabled the random generator with bias correction set
  RNGCTL = 0xC0;
  while(array_length--)
  {
    // Wait for the data ready bit to be set
    while((RNGCTL & 0x20) == 0);
    // Write the random data to the array
    *data_array++ = RNGDAT;
  }
}
void main()
{
  xdata uint8_t serial_number[16];
  
  // Configure the 2-wire interface in 400 kHz mode.
  hal_w2_configure_master(HAL_W2_400KHZ);

  // If the first byte of the designated serial number area is not 0xA3 the area is considered empty and the serial number must be written to the EEPROM
  if( m24c32_read_byte(M24C32_SERIAL_NUMBER_ADDRESS) != 0xA3 )
  {
    // Generate a random serial number
    generate_random_bytes(serial_number, 16);
    // Make sure the EEPROM is ready for new commands
    m24c32_wait_until_ready();
    // The first byte is set to 0xA3 to inform the system that the serial number is written into flash
    m24c32_write_byte(M24C32_SERIAL_NUMBER_ADDRESS, 0xA3);
    m24c32_wait_until_ready();
    // Write the serial number, starting at the second byte of the designated flash area
    m24c32_write_bytes(M24C32_SERIAL_NUMBER_ADDRESS + 1, serial_number, 16);
  }
  else
  {
    // If the serial number is already written to the EEPROM we read it back out
    m24c32_read_bytes(M24C32_SERIAL_NUMBER_ADDRESS + 1, serial_number, 16); 
  }   
    
  // The serial number can be found in the serial_number array. The first time the program runs it is randomly generated, and all following runs it will be read from the EEPROM. 
  while(1);
}